VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Objet3D"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Public Objet As New CD3DFrame
Dim mesh As New CD3DMesh

Public PosX As Single
Public PosY As Single
Public PosZ As Single

Public RotX As Single
Public RotY As Single
Public RotZ As Single

Public ScaleX As Single
Public ScaleY As Single
Public ScaleZ As Single

Public ChargerTextures As Boolean

Public RendreTransparent As Boolean


Sub CreerObjet(Chemin As String)
mesh.FermerTexture = Not ChargerTextures
mesh.InitFromFile g_dev, Chemin
Objet.AddMesh mesh
Objet.Optimize

ScaleX = 1
ScaleY = 1
ScaleZ = 1

Set mesh = Nothing
End Sub

Sub Afficher(Rendre As Boolean)
Objet.GetChildMesh(0).ComputeNormals

Objet.SetPosition vec3(PosX, PosY, PosZ)

Objet.AddRotation COMBINE_BEFORE, 1, 0, 0, RotX
Objet.AddRotation COMBINE_BEFORE, 0, 1, 0, RotY
Objet.AddRotation COMBINE_BEFORE, 0, 0, 1, RotZ

Objet.AddScale COMBINE_BEFORE, ScaleX, ScaleY, ScaleZ

If RendreTransparent = True Then
g_dev.SetRenderState D3DRS_ALPHABLENDENABLE, 1
g_dev.SetRenderState D3DRS_SRCBLEND, 3 '2
g_dev.SetRenderState D3DRS_DESTBLEND, 2 '4
End If

If Rendre = True Then
Objet.Render g_dev
Objet.RenderSkins
End If

If RendreTransparent = True Then g_dev.SetRenderState D3DRS_ALPHABLENDENABLE, 0


End Sub

Sub Supprimer()
mesh.Destroy
Objet.Destroy
Set Objet = Nothing
End Sub

Function Collision(Position As D3DVECTOR, Direction As D3DVECTOR) As Boolean
Dim col As New CD3DPick
Set col = New CD3DPick

col.RayPick Objet, Position, Direction

Dim f As Long

If col.GetCount > 0 Then
For f = 0 To col.GetCount '- 1

Dim i As Long, a As Single, b As Single, dist As Single, face As Long
  col.GetRecord f, a, b, dist, face
  dist = FormatNumber(dist * 10000, 0)
  If dist < 5 And dist <> 0 Then
  Collision = True
  End If
Next f

End If

'col.Destroy
'Set col = Nothing
End Function

Function GetHeight(Position As D3DVECTOR, Direction As D3DVECTOR, PosYDepart As Single, PosYFin As Single)
Dim Trouve As Boolean

Dim j As Single

GetHeight = Position.y

For j = PosYDepart To PosYFin Step -0.1
    If Collision(vec3(Position.x, j, Position.z), Direction) = True Then
      GetHeight = FormatNumber(j, 4)
      Trouve = True
      Exit For
  End If
Next j
'If Trouve = False Then
'GetHeight = Position.y - 0.1 'PosYFin
'End If
End Function


Function CollisionEx(Position As D3DVECTOR, Direction As D3DVECTOR, Precision As Single) As Boolean
Dim col As New CD3DPick

col.RayPick Objet, Position, Direction

Dim f As Long

If col.GetCount > 0 Then
For f = 0 To col.GetCount '- 1

Dim i As Long, a As Single, b As Single, dist As Single, face As Long
  col.GetRecord f, a, b, dist, face
  dist = FormatNumber(dist * 10000, 0)
  If dist < Precision And dist <> 0 Then
  CollisionEx = True
  End If
Next f

End If

col.Destroy
Set col = Nothing
End Function

Sub RendreInvalide()
Objet.InvalidateDeviceObjects
End Sub

Sub RendreValide()
Objet.RestoreDeviceObjects g_dev
End Sub

Sub FusionnerAvec(obj As Objet3D)
Objet.AddChild obj.Objet
Objet.GetChildFrame(Objet.GetChildFrameCount - 1).SetMatrix obj.Objet.GetMatrix
End Sub

Property Get ObjetMesh() As CD3DFrame
Set ObjetMesh = Objet
End Property

Sub DefMaterial(mat As D3DMATERIAL8)
For i = 0 To Objet.GetChildMesh(0).GetMaterialCount - 1
Objet.GetChildMesh(0).SetMaterial CLng(i), mat
Next i
End Sub

Sub DefTexture(tex As Direct3DTexture8)
For i = 0 To Objet.GetChildMesh(0).GetMaterialCount - 1
Objet.GetChildMesh(0).SetMaterialTexture CLng(i), tex
Next i
End Sub

Property Get GetTexture(index As Long) As Direct3DTexture8
Set GetTexture = Objet.GetChildMesh(0).GetMaterialTexture(index)
End Property
