VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Particules"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Dim Particules() As New Objet3D
Dim Angles() As Single
Dim NumParticules As Long
Dim DeplaceAvecX As Boolean, DeplaceAvecZ As Boolean

Dim TempsAttente() As Single

Public RendreTransparent As Boolean

Dim AnimAvecPhys As Boolean, mass As Single, grav As Single, frott As Single, vitesseDep As Single

Dim AnimerAvecRot As Boolean, angMax As Single, angMin As Single, vitesseRot As Single

Public LaisserParTerre As Boolean 'Savoir si on laisse les particules a la posYMin
Public AnglesParTerreX As Single, AnglesParTerreY As Single, AnglesParTerreZ As Single 'Angles x, y, z des particules une fois par terre

Public TempsMax As Single 'temps apres lequel la particule est remise a Ymax

Public Xmin As Single, Xmax As Single
Public Zmin As Single, Zmax As Single
Public Ymin As Single, Ymax As Single

Public ScaleX As Single
Public ScaleY As Single
Public ScaleZ As Single

Sub InitParticules(Chemin As String, CheminTexture As String, Nombre As Single, VecteurMax As D3DVECTOR, VecteurMin As D3DVECTOR)
If VecteurMin.x < VecteurMax.x Then
  Xmin = VecteurMin.x
  Xmax = VecteurMax.x
Else
  Xmin = VecteurMax.x
  Xmax = VecteurMin.x
End If
If VecteurMin.y < VecteurMax.y Then
  Ymin = VecteurMin.y
  Ymax = VecteurMax.y
Else
  Ymin = VecteurMax.y
  Ymax = VecteurMin.y
End If
If VecteurMin.z < VecteurMax.z Then
  Zmin = VecteurMin.z
  Zmax = VecteurMax.z
Else
  Zmin = VecteurMax.z
  Zmax = VecteurMin.z
End If

ScaleX = 1
ScaleY = 1
ScaleZ = 1

NumParticules = Nombre - 1
ReDim Particules(NumParticules)
ReDim Angles(NumParticules)
ReDim TempsAttente(NumParticules)
For i = 0 To NumParticules - 1

Particules(i).ChargerTextures = False

Particules(i).CreerObjet Chemin
Particules(i).DefTexture g_d3dx.CreateTextureFromFileEx(g_dev, CheminTexture, D3DX_DEFAULT, D3DX_DEFAULT, D3DX_DEFAULT, 0, D3DFMT_UNKNOWN, D3DPOOL_DEFAULT, D3DX_FILTER_LINEAR, D3DX_FILTER_LINEAR, &HFF000000, ByVal 0, ByVal 0)
Particules(i).PosX = Xmin + Rnd * (Xmax - Xmin)
Particules(i).PosY = Ymin + Rnd * (Ymax - Ymin)
Particules(i).PosZ = Zmin + Rnd * (Zmax - Zmin)
Next i
End Sub

'Masse en kg, gravit = 9.81 ...
Sub AnimerAvecProprietesPhysiques(masse As Single, gravite As Single, frottements As Single, vitesseDepart As Single, Activer As Boolean)
grav = gravite
If gravite <= 0 Then grav = 9.81

AnimAvecPhys = Activer
mass = masse
frott = frottements
vitesseDep = vitesseDepart
End Sub

Sub AnimerAvecRotationPif(Activer As Boolean, AngleMin As Single, AngleMax As Single, vitesse As Single)
angMin = AngleMin
angMax = AngleMax
vitesseRot = vitesse
AnimerAvecRot = Activer
End Sub

Sub InitAngleDeDeplacement(angMin As Single, angMax As Single)
For i = 0 To NumParticules - 1
If angMax > angMin Then Angles(i) = angMin + Rnd * (angMax - angMin)
If angMax < angMin Then Angles(i) = angMax + Rnd * (-angMax + angMin)
Next i
End Sub

Sub AnimerAvecAngleDeDeplacement(DeplacerAvecX As Boolean, DeplacerAvecZ As Boolean)
'For i = 0 To NumParticules - 1
DeplaceAvecX = DeplacerAvecX
DeplaceAvecZ = DeplacerAvecZ
'Next i
End Sub

Sub Rendre()
For i = 0 To NumParticules - 1

Particules(i).ScaleX = ScaleX
Particules(i).ScaleY = ScaleY
Particules(i).ScaleZ = ScaleZ

'Animer avec la physique
If AnimAvecPhys = True Then
Particules(i).PosY = Particules(i).PosY - (mass * grav * Abs((Ymax + vitesseDep) - Particules(i).PosY)) / frott
If LaisserParTerre = False Then
If Particules(i).PosY <= Ymin Or Particules(i).PosY > Ymax Then
    Particules(i).PosY = Ymax
    Particules(i).PosX = Xmin + Rnd * (Xmax - Xmin)
    Particules(i).PosZ = Zmin + Rnd * (Zmax - Zmin)
End If
Else

    
    If Particules(i).PosY <= Ymin Then
    
    
    Particules(i).PosY = Ymin
    If Particules(i).RotX <> 0 Then Particules(i).RotX = AnglesParTerreX
    If Particules(i).RotY <> 0 Then Particules(i).RotY = AnglesParTerreY
    If Particules(i).RotZ <> 0 Then Particules(i).RotZ = AnglesParTerreZ
    TempsAttente(i) = TempsAttente(i) + 1
    
    If TempsAttente(i) >= TempsMax Then
      Particules(i).PosY = Ymax + 1
      TempsAttente(i) = 0
    End If
    
    GoTo Rendu 'sauter les animations
    
    End If
End If
End If
'////////////////////////////////

'Deplacer Suivant X
If DeplaceAvecX = True Then
Particules(i).PosX = Particules(i).PosX + Cos(Angles(i)) / 10
End If
If DeplaceAvecZ = True Then
Particules(i).PosZ = Particules(i).PosZ + Sin(Angles(i)) / 10
End If
'//////////////////////////////


'Animer avec une rotation au hasard
If AnimerAvecRot = True Then
    Particules(i).RotX = Particules(i).RotX + (angMin + Rnd * (angMax - angMin)) / vitesseRot
    Particules(i).RotY = Particules(i).RotY + (angMin + Rnd * (angMax - angMin)) / vitesseRot
    Particules(i).RotZ = Particules(i).RotZ + (angMin + Rnd * (angMax - angMin)) / vitesseRot
End If
'//////////////////////////////////

Rendu:

g_dev.SetRenderState D3DRS_ALPHABLENDENABLE, 1

Particules(i).RendreTransparent = RendreTransparent

If ((g_d3dCaps.AlphaCmpCaps And D3DPCMPCAPS_GREATEREQUAL) = D3DPCMPCAPS_GREATEREQUAL) Then
        g_dev.SetRenderState D3DRS_ALPHATESTENABLE, 1 'TRUE
        g_dev.SetRenderState D3DRS_ALPHAREF, &H8&
        g_dev.SetRenderState D3DRS_ALPHAFUNC, D3DCMP_GREATEREQUAL
End If
g_dev.SetRenderState D3DRS_ZWRITEENABLE, 0
Particules(i).Afficher True
g_dev.SetRenderState D3DRS_ZWRITEENABLE, 1
Next i
End Sub


Sub RegarderPoint(Ptx As Single, Ptz As Single, Offset As Single, Reflete As Boolean)
Dim VecResultant As D3DVECTOR
For i = 0 To NumParticules - 1
VecResultant.x = Ptx - Particules(i).PosX
VecResultant.z = Ptz - Particules(i).PosZ

If Reflete = False Then
If VecResultant.x > 0 And VecResultant.x <> 0 Then
Particules(i).RotY = -Atn(VecResultant.z / VecResultant.x) - (g_pi / 2 + Offset)
Else
If VecResultant.x <> 0 Then Particules(i).RotY = -Atn(VecResultant.z / VecResultant.x) + (g_pi / 2 + Offset)
End If
End If

If Reflete = True Then
If VecResultant.x > 0 Then
Particules(i).RotY = Atn(VecResultant.z / VecResultant.x) - (g_pi / 2 + Offset)
Else
Particules(i).RotY = Atn(VecResultant.z / VecResultant.x) + (g_pi / 2 + Offset)
End If
End If
Next i
End Sub

Sub Supprimer()
For i = 0 To NumParticules - 1
Particules(i).Supprimer
Next i
ReDim Particules(0)
End Sub

Sub DefMaterial(mat As D3DMATERIAL8)
For i = 0 To NumParticules - 1
Particules(i).DefMaterial mat
Next i
End Sub

Function GetMaterial() As D3DMATERIAL8
GetMaterial = Particules(0).Objet.GetChildMesh(0).GetMaterial(0)
End Function
